import { Link } from "wouter";
import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import {
  Warehouse,
  Ship,
  Truck,
  FileText,
  Globe,
  Heart,
  CheckCircle,
} from "lucide-react";

export default function Services() {
  const services = [
    {
      icon: Warehouse,
      title: "Warehousing & Storage",
      description:
        "Secure warehouse facilities with inventory management, distribution services, and real-time tracking systems.",
      image:
        "https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=400",
      features: [
        "Climate-controlled storage facilities",
        "24/7 security monitoring",
        "Inventory management systems",
        "Distribution and fulfillment services",
      ],
    },
    {
      icon: Ship,
      title: "Freight Forwarding",
      description:
        "Multi-modal transportation solutions including air, sea, rail, and road freight services across East Africa.",
      image:
        "https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=400",
      features: [
        "Air freight services",
        "Ocean freight forwarding",
        "Rail transportation",
        "Door-to-door delivery",
      ],
    },
    {
      icon: Truck,
      title: "Road Transportation",
      description:
        "Reliable trucking services connecting Djibouti ports to Ethiopian markets with GPS tracking and secure handling.",
      image:
        "https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=400",
      features: [
        "GPS tracking systems",
        "Dedicated fleet management",
        "Cross-border expertise",
        "Specialized cargo handling",
      ],
    },
    {
      icon: FileText,
      title: "Customs Clearance",
      description:
        "Expert customs documentation and clearance services for smooth import/export operations across borders.",
      features: [
        "Import/export documentation",
        "Duty and tax calculation",
        "Regulatory compliance",
        "Fast-track clearance services",
      ],
    },
    {
      icon: Globe,
      title: "Supply Chain Solutions",
      description:
        "End-to-end supply chain management with real-time visibility and optimization for maximum efficiency.",
      features: [
        "Supply chain optimization",
        "Demand forecasting",
        "Vendor management",
        "Real-time tracking and reporting",
      ],
    },
    {
      icon: Heart,
      title: "Aid Cargo Handling",
      description:
        "Specialized handling of humanitarian aid and relief cargo with priority processing and secure delivery.",
      features: [
        "Priority processing",
        "Humanitarian cargo expertise",
        "Emergency response logistics",
        "NGO partnership programs",
      ],
    },
  ];

  return (
    <div className="py-20">
      {/* Hero Section */}
      <section className="bg-gradient-to-r from-primary to-secondary py-20 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h1 className="text-4xl md:text-6xl font-bold mb-6">Our Services</h1>
          <p className="text-xl md:text-2xl text-slate-200 mb-8 max-w-3xl mx-auto">
            Comprehensive logistics solutions tailored for the Horn of Africa
            region
          </p>
          <Button
            asChild
            size="lg"
            className="bg-accent hover:bg-orange-600 text-white"
          >
            <Link href="/quotation">Get Service Quote</Link>
          </Button>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-16">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card key={index} className="bg-white shadow-xl">
                  <CardContent className="p-0">
                    <div
                      className={`grid lg:grid-cols-2 gap-8 ${index % 2 === 1 ? "lg:grid-flow-col-dense" : ""}`}
                    >
                      <div
                        className={`p-8 lg:p-12 ${index % 2 === 1 ? "lg:col-start-2" : ""}`}
                      >
                        <div className="flex items-center mb-6">
                          <div className="bg-primary/10 rounded-full p-3 mr-4">
                            <Icon className="h-8 w-8 text-primary" />
                          </div>
                          <h2 className="text-3xl font-bold text-gray-800">
                            {service.title}
                          </h2>
                        </div>
                        <p className="text-lg text-neutral mb-8">
                          {service.description}
                        </p>
                        <div className="space-y-3 mb-8">
                          {service.features.map((feature, featureIndex) => (
                            <div
                              key={featureIndex}
                              className="flex items-center"
                            >
                              <CheckCircle className="h-5 w-5 text-success mr-3 flex-shrink-0" />
                              <span className="text-gray-700">{feature}</span>
                            </div>
                          ))}
                        </div>
                        <Button
                          asChild
                          className="bg-primary hover:bg-secondary"
                        >
                          <Link href="/quotation">Request Quote</Link>
                        </Button>
                      </div>
                      <div
                        className={`${index % 2 === 1 ? "lg:col-start-1" : ""}`}
                      >
                        {service.image ? (
                          <img
                            src={service.image}
                            alt={service.title}
                            className="w-full h-64 lg:h-full object-cover"
                          />
                        ) : (
                          <div className="w-full h-64 lg:h-full bg-gradient-to-br from-primary to-secondary flex items-center justify-center">
                            <Icon className="h-24 w-24 text-white/50" />
                          </div>
                        )}
                      </div>
                    </div>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-white">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl font-bold text-gray-800 mb-4">
            Ready to Get Started?
          </h2>
          <p className="text-xl text-neutral mb-8">
            Contact our logistics experts to discuss your specific requirements
            and get a customized solution.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button
              asChild
              size="lg"
              className="bg-accent hover:bg-orange-600 text-white"
            >
              <Link href="/quotation">Request Quote</Link>
            </Button>
            <Button asChild size="lg" variant="outline">
              <Link href="/contact">Contact Us</Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}
