import { Link } from "wouter";
import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Handshake, Network, Globe, CheckCircle } from "lucide-react";

export default function Partners() {
  const partnerships = [
    {
      icon: Handshake,
      title: "AOP Network",
      description: "Member of Africa Organization for Professionals, expanding our regional reach and expertise."
    },
    {
      icon: Network,
      title: "C5C Alliance",
      description: "Strategic alliance providing enhanced logistics capabilities and global connectivity."
    },
    {
      icon: Globe,
      title: "Frontline Logistics",
      description: "Partnership enabling comprehensive supply chain solutions across multiple countries."
    }
  ];

  const benefits = [
    "Access to regional trade networks",
    "Shared resources and expertise",
    "Joint marketing opportunities",
    "Technology platform integration"
  ];

  return (
    <div className="py-20">
      {/* Hero Section */}
      <section className="bg-gradient-to-r from-primary to-secondary py-20 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <Handshake className="h-16 w-16 text-accent mx-auto mb-6" />
          <h1 className="text-4xl md:text-6xl font-bold mb-6">Our Strategic Partners</h1>
          <p className="text-xl md:text-2xl text-slate-200 mb-8 max-w-3xl mx-auto">
            Collaborating with leading organizations to provide comprehensive logistics solutions across the Horn of Africa.
          </p>
        </div>
      </section>

      {/* Partnership Benefits */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid md:grid-cols-3 gap-8 mb-16">
            {partnerships.map((partnership, index) => {
              const Icon = partnership.icon;
              return (
                <div key={index} className="text-center">
                  <div className="bg-white rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <Icon className="h-10 w-10 text-primary" />
                  </div>
                  <h3 className="text-xl font-semibold text-gray-800 mb-2">{partnership.title}</h3>
                  <p className="text-neutral">{partnership.description}</p>
                </div>
              );
            })}
          </div>
        </div>
      </section>

      {/* Partner Benefits Section */}
      <section className="py-20 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <Card className="shadow-xl">
            <CardContent className="p-8 md:p-12">
              <div className="grid lg:grid-cols-2 gap-12 items-center">
                <div>
                  <img 
                    src="https://images.unsplash.com/photo-1521737711867-e3b97375f902?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=600" 
                    alt="Professional business team" 
                    className="rounded-xl shadow-lg w-full h-auto"
                  />
                </div>
                <div>
                  <h3 className="text-3xl font-bold text-gray-800 mb-6">Become a Partner</h3>
                  <p className="text-lg text-neutral mb-6">
                    Join our growing network of logistics partners and expand your business opportunities in the Horn of Africa region.
                  </p>
                  
                  <div className="space-y-4 mb-8">
                    {benefits.map((benefit, index) => (
                      <div key={index} className="flex items-center">
                        <CheckCircle className="h-6 w-6 text-success mr-3 flex-shrink-0" />
                        <span className="text-gray-700">{benefit}</span>
                      </div>
                    ))}
                  </div>
                  
                  <Button asChild size="lg" className="bg-accent hover:bg-orange-600 text-white">
                    <Link href="/contact">
                      <Handshake className="h-5 w-5 mr-2" />
                      Partner With Us
                    </Link>
                  </Button>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Partnership Types */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-gray-800 mb-4">Partnership Opportunities</h2>
            <p className="text-xl text-neutral max-w-3xl mx-auto">
              We offer various partnership models to suit different business needs and objectives.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <Card className="shadow-lg hover:shadow-xl transition-shadow">
              <CardContent className="p-8 text-center">
                <div className="bg-primary/10 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-6">
                  <Network className="h-8 w-8 text-primary" />
                </div>
                <h3 className="text-xl font-semibold text-gray-800 mb-4">Agent Network</h3>
                <p className="text-neutral mb-6">
                  Become a local agent representing our services in your region with dedicated support and training.
                </p>
                <Button asChild variant="outline">
                  <Link href="/contact">Learn More</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="shadow-lg hover:shadow-xl transition-shadow">
              <CardContent className="p-8 text-center">
                <div className="bg-primary/10 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-6">
                  <Globe className="h-8 w-8 text-primary" />
                </div>
                <h3 className="text-xl font-semibold text-gray-800 mb-4">Strategic Alliance</h3>
                <p className="text-neutral mb-6">
                  Form strategic alliances for joint ventures, shared resources, and expanded market reach.
                </p>
                <Button asChild variant="outline">
                  <Link href="/contact">Learn More</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="shadow-lg hover:shadow-xl transition-shadow">
              <CardContent className="p-8 text-center">
                <div className="bg-primary/10 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-6">
                  <Handshake className="h-8 w-8 text-primary" />
                </div>
                <h3 className="text-xl font-semibold text-gray-800 mb-4">Service Provider</h3>
                <p className="text-neutral mb-6">
                  Join our network of trusted service providers offering specialized logistics solutions.
                </p>
                <Button asChild variant="outline">
                  <Link href="/contact">Learn More</Link>
                </Button>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>
    </div>
  );
}
