import { Card, CardContent } from "@/components/ui/card";
import { Quote } from "lucide-react";

export default function TestimonialsSection() {
  const testimonials = [
    {
      content: "SiyanTransit Express has been instrumental in our supply chain success. Their expertise in the Djibouti-Ethiopia corridor is unmatched, and their team consistently delivers on time.",
      author: "Ahmed Hassan",
      company: "Import/Export Manager",
      initial: "A"
    },
    {
      content: "Professional service and reliable delivery times. Their warehousing facilities in Djibouti have significantly improved our inventory management and distribution efficiency.",
      author: "Sarah Mohammed",
      company: "Logistics Director",
      initial: "S"
    },
    {
      content: "Excellent customs clearance support and documentation handling. Their expertise has saved us time and reduced costs significantly in our cross-border operations.",
      author: "Michael Tadesse",
      company: "Operations Manager",
      initial: "M"
    }
  ];

  return (
    <section className="py-20 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl font-bold text-gray-800 mb-4">What Our Clients Say</h2>
          <p className="text-xl text-neutral max-w-3xl mx-auto">
            Trusted by businesses across the Horn of Africa for reliable logistics solutions.
          </p>
        </div>

        <div className="grid lg:grid-cols-3 gap-8">
          {testimonials.map((testimonial, index) => (
            <Card key={index} className="bg-slate-50 shadow-lg">
              <CardContent className="p-8">
                <div className="flex items-center mb-4">
                  <Quote className="h-6 w-6 text-accent" />
                </div>
                <p className="text-gray-700 mb-6 italic">{testimonial.content}</p>
                <div className="flex items-center">
                  <div className="w-12 h-12 bg-primary rounded-full flex items-center justify-center text-white font-semibold mr-4">
                    {testimonial.initial}
                  </div>
                  <div>
                    <div className="font-semibold text-gray-800">{testimonial.author}</div>
                    <div className="text-neutral text-sm">{testimonial.company}</div>
                  </div>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
}
