import { Link } from "wouter";
import { Card, CardContent } from "@/components/ui/card";
import { Warehouse, Ship, Truck, FileText, Globe, Heart, ArrowRight } from "lucide-react";

export default function ServicesSection() {
  const services = [
    {
      icon: Warehouse,
      title: "Warehousing & Storage",
      description: "Secure warehouse facilities with inventory management, distribution services, and real-time tracking systems.",
      image: "https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=400"
    },
    {
      icon: Ship,
      title: "Freight Forwarding",
      description: "Multi-modal transportation solutions including air, sea, rail, and road freight services across East Africa.",
      image: "https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=400"
    },
    {
      icon: Truck,
      title: "Road Transportation",
      description: "Reliable trucking services connecting Djibouti ports to Ethiopian markets with GPS tracking and secure handling.",
      image: "https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=400"
    },
    {
      icon: FileText,
      title: "Customs Clearance",
      description: "Expert customs documentation and clearance services for smooth import/export operations across borders."
    },
    {
      icon: Globe,
      title: "Supply Chain Solutions",
      description: "End-to-end supply chain management with real-time visibility and optimization for maximum efficiency."
    },
    {
      icon: Heart,
      title: "Aid Cargo Handling",
      description: "Specialized handling of humanitarian aid and relief cargo with priority processing and secure delivery."
    }
  ];

  return (
    <section className="py-20 bg-slate-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl font-bold text-gray-800 mb-4">Our Logistics Services</h2>
          <p className="text-xl text-neutral max-w-3xl mx-auto">
            Comprehensive logistics solutions tailored for the Horn of Africa region, specializing in Djibouti-Ethiopia trade corridor.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {services.map((service, index) => {
            const Icon = service.icon;
            return (
              <Card key={index} className="bg-white shadow-lg hover:shadow-xl transition-shadow">
                <CardContent className="p-8">
                  {service.image && (
                    <img 
                      src={service.image} 
                      alt={service.title}
                      className="w-full h-48 object-cover rounded-lg mb-6"
                    />
                  )}
                  <div className="text-primary text-4xl mb-4">
                    <Icon className="h-10 w-10" />
                  </div>
                  <h3 className="text-2xl font-semibold text-gray-800 mb-4">{service.title}</h3>
                  <p className="text-neutral mb-6">{service.description}</p>
                  <Link 
                    href="/quotation" 
                    className="text-primary font-medium hover:text-secondary inline-flex items-center"
                  >
                    Learn More <ArrowRight className="h-4 w-4 ml-1" />
                  </Link>
                </CardContent>
              </Card>
            );
          })}
        </div>
      </div>
    </section>
  );
}
