import { useState } from "react";
import { Link } from "wouter";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Search, Calculator, Truck } from "lucide-react";

export default function HeroSection() {
  const [trackingNumber, setTrackingNumber] = useState("");

  const handleTrackShipment = () => {
    if (trackingNumber.trim()) {
      // TODO: Implement tracking functionality
      alert(`Tracking shipment: ${trackingNumber}`);
    }
  };

  return (
    <section className="relative bg-gradient-to-r from-primary to-secondary py-20 lg:py-32">
      {/* Background overlay */}
      <div className="absolute inset-0 bg-black bg-opacity-40"></div>
      <div 
        className="absolute inset-0 bg-cover bg-center"
        style={{
          backgroundImage: "url('https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=1920&h=1080')"
        }}
      />
      
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center">
          <h1 className="text-4xl md:text-6xl font-bold text-white mb-6">
            Professional Logistics & 
            <span className="text-accent"> Freight Solutions</span>
          </h1>
          <p className="text-xl md:text-2xl text-slate-200 mb-8 max-w-3xl mx-auto">
            Connecting Djibouti and Ethiopia with reliable multi-modal transportation, warehousing, and supply chain solutions since 2008.
          </p>
          
          {/* Tracking Widget */}
          <div className="bg-white rounded-xl shadow-2xl p-6 md:p-8 max-w-2xl mx-auto mb-8">
            <h3 className="text-2xl font-semibold text-gray-800 mb-4">Track Your Shipment</h3>
            <div className="flex flex-col md:flex-row gap-4">
              <Input
                type="text"
                placeholder="Enter tracking number"
                value={trackingNumber}
                onChange={(e) => setTrackingNumber(e.target.value)}
                className="flex-1"
              />
              <Button 
                onClick={handleTrackShipment}
                className="bg-primary hover:bg-secondary text-white px-8 py-3"
              >
                <Search className="h-4 w-4 mr-2" />
                Track Now
              </Button>
            </div>
          </div>

          {/* Primary CTAs */}
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" className="bg-accent hover:bg-orange-600 text-white px-8 py-4 text-lg">
              <Link href="/quotation">
                <Calculator className="h-5 w-5 mr-2" />
                Get Free Quote
              </Link>
            </Button>
            <Button asChild size="lg" variant="outline" className="bg-white text-primary hover:bg-slate-100 px-8 py-4 text-lg border-0">
              <Link href="/services">
                <Truck className="h-5 w-5 mr-2" />
                Our Services
              </Link>
            </Button>
          </div>
        </div>
      </div>
    </section>
  );
}
