# SiyanTransit Express - Logistics Website

This is a professional logistics company website built with Node.js, Express, React, and PostgreSQL.

## Features
- Complete logistics company website
- Quotation request system
- Contact form management
- PostgreSQL database integration
- Responsive design with modern UI
- Professional blue and orange color scheme

## Project Structure
- `client/` - React frontend application
- `server/` - Express.js backend with API routes
- `shared/` - Common schemas and types
- Database: PostgreSQL with Drizzle ORM

## Setup Instructions
1. Install Node.js (v20 or higher)
2. Run `npm install` to install dependencies
3. Set up PostgreSQL database and configure DATABASE_URL
4. Run `npm run db:push` to create database tables
5. Run `npm run dev` to start the development server

## Technologies Used
- Frontend: React 18, Vite, Tailwind CSS, shadcn/ui
- Backend: Express.js, TypeScript
- Database: PostgreSQL with Drizzle ORM
- Styling: Tailwind CSS with custom color scheme
- Form Handling: React Hook Form with Zod validation

## Environment Variables Required
- DATABASE_URL - PostgreSQL connection string
- Other database connection variables (PGHOST, PGPORT, etc.)

Exported on: $(date)
