# Overview

This is a full-stack web application for SiyanTransit Express, a logistics and freight forwarding company operating in the Horn of Africa, specifically the Djibouti-Ethiopia trade corridor. The application provides a professional website with services information, quotation requests, contact forms, and business partnerships details.

# User Preferences

Preferred communication style: Simple, everyday language.

# System Architecture

## Frontend Architecture
- **React 18** with TypeScript for the user interface
- **Vite** as the build tool and development server
- **Wouter** for client-side routing (lightweight alternative to React Router)
- **TanStack Query** for server state management and API calls
- **Tailwind CSS** with **shadcn/ui** component library for styling
- **React Hook Form** with **Zod** for form validation
- Component structure organized into pages, sections, and reusable UI components
- Responsive design with mobile-first approach

## Backend Architecture
- **Express.js** server with TypeScript
- **Drizzle ORM** for database operations and schema management
- **Neon Database** (PostgreSQL) for data persistence
- RESTful API endpoints for quotations, contact messages, and data retrieval
- Middleware for request logging and error handling
- Database schema includes users, quotation requests, and contact messages tables

## Application Structure
- **Monorepo setup** with shared types and schemas between client and server
- **client/** - React frontend application
- **server/** - Express backend with API routes
- **shared/** - Common schemas and types used by both frontend and backend
- Development and production build processes with ESM modules

## Key Features
- **Multi-page website** with home, services, quotation, partners, and contact pages
- **Quotation request system** with comprehensive form validation
- **Contact messaging** with subject categorization
- **Responsive navigation** with mobile menu support
- **Toast notifications** for user feedback
- **Shipment tracking interface** (placeholder implementation)

## Data Layer
- **PostgreSQL database** with UUID primary keys
- **Drizzle migrations** for schema versioning
- **Type-safe database operations** with generated TypeScript types
- **Validation schemas** shared between client and server using Zod

## Development Workflow
- **Hot module replacement** in development via Vite
- **TypeScript compilation** with strict mode enabled
- **Path aliases** for clean imports (@/, @shared/)
- **Development logging** with request/response tracking
- **Error boundaries** and runtime error overlays for debugging

# External Dependencies

## Database
- **Neon Database** (PostgreSQL) - Serverless PostgreSQL database
- **Drizzle ORM** - Type-safe database toolkit and query builder
- **WebSocket connection** via ws package for Neon serverless compatibility

## UI Framework & Styling  
- **React 18** - Frontend framework
- **Tailwind CSS** - Utility-first CSS framework
- **Radix UI** - Headless UI components for accessibility
- **shadcn/ui** - Pre-built component system built on Radix UI
- **Lucide React** - Icon library

## Form Handling & Validation
- **React Hook Form** - Form state management
- **Zod** - TypeScript-first schema validation
- **@hookform/resolvers** - Validation resolver for React Hook Form

## State Management & Data Fetching
- **TanStack Query** - Server state management and caching
- **Wouter** - Lightweight client-side routing

## Development Tools
- **Vite** - Build tool and development server  
- **TypeScript** - Static type checking
- **PostCSS** - CSS processing with Autoprefixer
- **esbuild** - Fast JavaScript bundler for production builds

## Hosting Platform Integration
- **Replit** - Development environment with specialized plugins for error handling and debugging
- **@replit/vite-plugin-runtime-error-modal** - Runtime error overlays
- **@replit/vite-plugin-cartographer** - Development tooling integration