import { Link } from "wouter";
import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import {
  Warehouse,
  Ship,
  Truck,
  FileText,
  Globe,
  Heart,
  Anchor,
  CheckCircle,
} from "lucide-react";

export default function Services() {
  const services = [
    {
      icon: Anchor,
      title: "Sea Port Operations",
      description:
        "Comprehensive port services at Djibouti seaport including cargo handling, container operations, and vessel management with follow-up of accosting ships and maritime companies.",
      image: "/seaport operations.jpg",
      features: [
        "24/7 port operations management",
        "Container loading and unloading services",
        "Vessel scheduling and coordination",
        "Maritime documentation handling",
      ],
    },
    {
      icon: Warehouse,
      title: "Warehousing & Storage",
      description:
        "Secure warehouse facilities with inventory management, distribution services, and global vision of the whole supply chain from point of loading up to delivery.",
      image: "/warehouse-interior-with-forklifts-shelving.jpg",
      features: [
        "Climate-controlled storage facilities",
        "24/7 security monitoring",
        "Inventory management systems",
        "Distribution and fulfillment services",
      ],
    },
    {
      icon: Ship,
      title: "Freight Forwarding",
      description:
        "Import/Export by Air, Ocean and road. Multi-modal transportation solutions across East Africa with representative agent services for partner needs in Djibouti and Ethiopia.",
      image: "/Logistic-service-.png",
      features: [
        "Air freight services",
        "Ocean freight forwarding",
        "Rail transportation",
        "Door-to-door delivery",
      ],
    },
    {
      icon: FileText,
      title: "Customs Clearance",
      description:
        "Expert customs documentation and clearance services including preparation of transit files, control of import/export documents, and handling of customs formalities.",
      image: "/customs-clearance.jpg",
      features: [
        "Import/export documentation",
        "Duty and tax calculation",
        "Regulatory compliance",
        "Fast-track clearance services",
      ],
    },
    {
      icon: Globe,
      title: "Supply Chain Solutions",
      description:
        "End-to-end supply chain management with delivery to beforehand indicated sites, pre-routing and choices implementation as regards means to implement.",
      image: "/supply-chain.jpg",
      features: [
        "Supply chain optimization",
        "Demand forecasting",
        "Vendor management",
        "Real-time tracking and reporting",
      ],
    },
    {
      icon: Heart,
      title: "Customized Services",
      description:
        "Safely and quick delivery of your cargo with accurate information on daily basis. Step by step follow up and timely information given by Siyan will give you a clear picture of your cargo as if you are on spot.",
      image: "/customized service.jpg",
      features: [
        "Priority processing",
        "Tailored logistics solutions",
        "Real-time cargo tracking",
        "Daily status updates",
      ],
    },
    {
      icon: Truck,
      title: "Trading Services",
      description:
        "Representative agent for any partner needs to be represented in Djibouti and Ethiopia. Call of goods abroad at customer request when necessary.",
      image: "/Trading Services.jpg",
      features: [
        "Local representation services",
        "Market research and analysis",
        "Supplier identification and vetting",
        "Procurement and sourcing",
      ],
    },
    {
      icon: Globe,
      title: "IT Logistics Solutions",
      description:
        "As information technology expands, we take advantage of the latest technology. Siyan is developing a Tracking system enabling you to trace your shipment whenever and wherever you want.",
      image: "/IT Logistics Solutions.jpg",
      features: [
        "Real-time shipment tracking",
        "Digital documentation management",
        "Automated reporting systems",
        "Mobile app accessibility",
      ],
    },
  ];

  return (
    <div className="py-20">
      {/* Hero Section */}
      <section className="bg-gradient-to-r from-primary to-secondary py-20 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h1 className="text-4xl md:text-6xl font-bold mb-6">Our Services</h1>
          <p className="text-xl md:text-2xl text-slate-200 mb-8 max-w-3xl mx-auto">
            Comprehensive logistics solutions tailored for the Horn of Africa
            region
          </p>
          <Button
            asChild
            size="lg"
            className="bg-accent hover:bg-orange-600 text-white"
          >
            <Link href="/quotation">Get Service Quote</Link>
          </Button>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-16">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card key={index} className="bg-white shadow-xl">
                  <CardContent className="p-0">
                    <div
                      className={`grid lg:grid-cols-2 gap-8 ${index % 2 === 1 ? "lg:grid-flow-col-dense" : ""}`}
                    >
                      <div
                        className={`p-8 lg:p-12 ${index % 2 === 1 ? "lg:col-start-2" : ""}`}
                      >
                        <div className="flex items-center mb-6">
                          <div className="bg-primary/10 rounded-full p-3 mr-4">
                            <Icon className="h-8 w-8 text-primary" />
                          </div>
                          <h2 className="text-3xl font-bold text-gray-800">
                            {service.title}
                          </h2>
                        </div>
                        <p className="text-lg text-neutral mb-8">
                          {service.description}
                        </p>
                        <div className="space-y-3 mb-8">
                          {service.features.map((feature, featureIndex) => (
                            <div
                              key={featureIndex}
                              className="flex items-center"
                            >
                              <CheckCircle className="h-5 w-5 text-success mr-3 flex-shrink-0" />
                              <span className="text-gray-700">{feature}</span>
                            </div>
                          ))}
                        </div>
                        <Button
                          asChild
                          className="bg-primary hover:bg-secondary"
                        >
                          <Link href="/quotation">Request Quote</Link>
                        </Button>
                      </div>
                      <div
                        className={`${index % 2 === 1 ? "lg:col-start-1" : ""}`}
                      >
                        {service.image ? (
                          <img
                            src={service.image}
                            alt={service.title}
                            className="w-full h-64 lg:h-full object-cover"
                          />
                        ) : (
                          <div className="w-full h-64 lg:h-full bg-gradient-to-br from-primary to-secondary flex items-center justify-center">
                            <Icon className="h-24 w-24 text-white/50" />
                          </div>
                        )}
                      </div>
                    </div>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-white">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl font-bold text-gray-800 mb-4">
            Ready to Get Started?
          </h2>
          <p className="text-xl text-neutral mb-8">
            Contact our logistics experts to discuss your specific requirements
            and get a customized solution.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button
              asChild
              size="lg"
              className="bg-accent hover:bg-orange-600 text-white"
            >
              <Link href="/quotation">Request Quote</Link>
            </Button>
            <Button asChild size="lg" variant="outline">
              <Link href="/contact">Contact Us</Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}
