import { Link, useLocation } from "wouter";
import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import {
  Warehouse,
  Ship,
  Truck,
  FileText,
  Globe,
  Heart,
  Anchor,
  ArrowLeft,
  CheckCircle,
  Clock,
  Shield,
  Users
} from "lucide-react";

export default function LearnMore() {
  const [location] = useLocation();
  const urlParams = new URLSearchParams(location.split('?')[1] || '');
  const serviceParam = urlParams.get('service');
  const services = [
    {
      icon: Anchor,
      title: "Sea Port Operations",
      description: "Comprehensive port services at Djibouti seaport including cargo handling, container operations, and vessel management with follow-up of accosting ships and maritime companies.",
      image: "/seaport operations.jpg",
      details: [
        "24/7 port operations management",
        "Container loading and unloading services",
        "Vessel scheduling and coordination",
        "Maritime documentation handling",
        "Cargo inspection and quality control",
        "Port security and safety compliance"
      ],
      benefits: [
        "Strategic location at the Horn of Africa",
        "Modern port facilities and equipment",
        "Experienced maritime professionals",
        "Direct access to Ethiopian markets"
      ]
    },
    {
      icon: Warehouse,
      title: "Warehousing & Storage",
      description: "Secure warehouse facilities with inventory management, distribution services, and global vision of the whole supply chain from point of loading up to delivery.",
      image: "/warehouse-interior-with-forklifts-shelving.jpg",
      details: [
        "Climate-controlled storage facilities",
        "Real-time inventory tracking systems",
        "Pick and pack services",
        "Cross-docking capabilities",
        "Distribution and fulfillment",
        "Quality control and inspection"
      ],
      benefits: [
        "Secure 24/7 monitored facilities",
        "Flexible storage solutions",
        "Advanced warehouse management systems",
        "Strategic location for regional distribution"
      ]
    },
    {
      icon: Ship,
      title: "Freight Forwarding",
      description: "Import/Export by Air, Ocean and road. Multi-modal transportation solutions across East Africa with representative agent services for partner needs in Djibouti and Ethiopia.",
      image: "/Logistic-service-.png",
      details: [
        "Air freight services worldwide",
        "Ocean freight forwarding",
        "Road transportation networks",
        "Rail freight coordination",
        "Door-to-door delivery services",
        "Customs clearance assistance"
      ],
      benefits: [
        "Multi-modal transportation options",
        "Competitive shipping rates",
        "Global network of partners",
        "End-to-end logistics solutions"
      ]
    },
    {
      icon: FileText,
      title: "Customs Clearance",
      description: "Expert customs documentation and clearance services including preparation of transit files, control of import/export documents, and handling of customs formalities.",
      image: "/customs-clearance.jpg",
      details: [
        "Import/export documentation preparation",
        "Duty and tax calculation",
        "Regulatory compliance management",
        "Fast-track clearance services",
        "Transit documentation",
        "Government liaison services"
      ],
      benefits: [
        "Expert knowledge of local regulations",
        "Reduced clearance times",
        "Compliance assurance",
        "Cost-effective solutions"
      ]
    },
    {
      icon: Globe,
      title: "Supply Chain Solutions",
      description: "End-to-end supply chain management with delivery to beforehand indicated sites, pre-routing and choices implementation as regards means to implement.",
      image: "/supply-chain.jpg",
      details: [
        "Supply chain optimization",
        "Demand forecasting and planning",
        "Vendor management services",
        "Real-time tracking and reporting",
        "Risk management and mitigation",
        "Performance analytics and insights"
      ],
      benefits: [
        "Improved operational efficiency",
        "Cost reduction opportunities",
        "Enhanced visibility and control",
        "Scalable solutions for growth"
      ]
    },
    {
      icon: Heart,
      title: "Customized Services",
      description: "Safely and quick delivery of your cargo with accurate information on daily basis. Step by step follow up and timely information given by Siyan will give you a clear picture of your cargo as if you are on spot.",
      image: "/customized service.jpg",
      details: [
        "Tailored logistics solutions",
        "Dedicated account management",
        "Real-time cargo tracking",
        "Daily status updates",
        "Emergency response services",
        "Specialized handling requirements"
      ],
      benefits: [
        "Personalized service approach",
        "Flexible and adaptable solutions",
        "Proactive communication",
        "Peace of mind with full visibility"
      ]
    },
    {
      icon: Truck,
      title: "Trading Services",
      description: "Representative agent for any partner needs to be represented in Djibouti and Ethiopia. Call of goods abroad at customer request when necessary.",
      image: "/Trading Services.jpg",
      details: [
        "Local representation services",
        "Market research and analysis",
        "Supplier identification and vetting",
        "Procurement and sourcing",
        "Quality control and inspection",
        "Payment and financial coordination"
      ],
      benefits: [
        "Local market expertise",
        "Established business networks",
        "Cultural and language advantages",
        "Reduced operational complexity"
      ]
    },
    {
      icon: Globe,
      title: "IT Logistics Solutions",
      description: "As information technology expands, we take advantage of the latest technology. Siyan is developing a Tracking system enabling you to trace your shipment whenever and wherever you want.",
      image: "/IT Logistics Solutions.jpg",
      details: [
        "Real-time shipment tracking",
        "Digital documentation management",
        "Automated reporting systems",
        "Mobile app accessibility",
        "API integration capabilities",
        "Data analytics and insights"
      ],
      benefits: [
        "Enhanced transparency and visibility",
        "Improved operational efficiency",
        "Reduced paperwork and errors",
        "24/7 access to information"
      ]
    }
  ];

  return (
    <div className="py-20">
      {/* Hero Section */}
      <section className="bg-gradient-to-r from-primary to-secondary py-20 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl md:text-6xl font-bold mb-6">Learn More About Our Services</h1>
            <p className="text-xl md:text-2xl text-slate-200 mb-8 max-w-4xl mx-auto">
              Discover the comprehensive details of our logistics solutions and how we can help streamline your supply chain operations across East Africa.
            </p>
            <Button asChild size="lg" variant="outline" className="bg-white/10 backdrop-blur-sm text-white hover:bg-white hover:text-primary border-white/30">
              <Link href="/services">
                <ArrowLeft className="h-5 w-5 mr-2" />
                Back to Services
              </Link>
            </Button>
          </div>
        </div>
      </section>

      {/* Detailed Services Section */}
      <section className="py-20 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-20">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card key={index} className="bg-white shadow-xl overflow-hidden">
                  <CardContent className="p-0">
                    <div className={`grid lg:grid-cols-2 gap-0 ${index % 2 === 1 ? "lg:grid-flow-col-dense" : ""}`}>
                      {/* Image Section */}
                      <div className={`relative ${index % 2 === 1 ? "lg:col-start-1" : ""}`}>
                        <img
                          src={service.image}
                          alt={service.title}
                          className="w-full h-64 lg:h-full object-cover"
                        />
                        <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent lg:hidden"></div>
                      </div>
                      
                      {/* Content Section */}
                      <div className={`p-8 lg:p-12 ${index % 2 === 1 ? "lg:col-start-2" : ""}`}>
                        <div className="flex items-center mb-6">
                          <div className="bg-primary/10 rounded-full p-4 mr-4">
                            <Icon className="h-10 w-10 text-primary" />
                          </div>
                          <h2 className="text-3xl lg:text-4xl font-bold text-gray-800">
                            {service.title}
                          </h2>
                        </div>
                        
                        <p className="text-lg text-neutral mb-8 leading-relaxed">
                          {service.description}
                        </p>

                        {/* Service Details */}
                        <div className="mb-8">
                          <h3 className="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                            <CheckCircle className="h-5 w-5 text-success mr-2" />
                            What We Offer
                          </h3>
                          <div className="grid md:grid-cols-2 gap-3">
                            {service.details.map((detail, detailIndex) => (
                              <div key={detailIndex} className="flex items-start">
                                <div className="w-2 h-2 bg-primary rounded-full mt-2 mr-3 flex-shrink-0"></div>
                                <span className="text-gray-700">{detail}</span>
                              </div>
                            ))}
                          </div>
                        </div>

                        {/* Benefits */}
                        <div className="mb-8">
                          <h3 className="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                            <Shield className="h-5 w-5 text-success mr-2" />
                            Key Benefits
                          </h3>
                          <div className="space-y-3">
                            {service.benefits.map((benefit, benefitIndex) => (
                              <div key={benefitIndex} className="flex items-center">
                                <CheckCircle className="h-5 w-5 text-success mr-3 flex-shrink-0" />
                                <span className="text-gray-700 font-medium">{benefit}</span>
                              </div>
                            ))}
                          </div>
                        </div>

                        {/* CTA Buttons */}
                        <div className="flex flex-col sm:flex-row gap-4">
                          <Button asChild className="bg-primary hover:bg-secondary">
                            <Link href="/quotation">
                              Get Quote for {service.title}
                            </Link>
                          </Button>
                          <Button asChild variant="outline">
                            <Link href="/contact">
                              Contact Our Experts
                            </Link>
                          </Button>
                        </div>
                      </div>
                    </div>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* Why Choose Us Section */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-gray-800 mb-4">Why Choose Siyan Trans Express?</h2>
            <p className="text-xl text-neutral max-w-3xl mx-auto">
              We combine local expertise with international standards to deliver exceptional logistics solutions.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="text-center">
              <div className="bg-primary/10 rounded-full p-6 w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                <Clock className="h-10 w-10 text-primary" />
              </div>
              <h3 className="text-xl font-semibold text-gray-800 mb-2">24/7 Operations</h3>
              <p className="text-neutral">Round-the-clock service to meet your urgent logistics needs.</p>
            </div>

            <div className="text-center">
              <div className="bg-primary/10 rounded-full p-6 w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                <Shield className="h-10 w-10 text-primary" />
              </div>
              <h3 className="text-xl font-semibold text-gray-800 mb-2">Secure & Reliable</h3>
              <p className="text-neutral">Advanced security measures and reliable service delivery.</p>
            </div>

            <div className="text-center">
              <div className="bg-primary/10 rounded-full p-6 w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                <Users className="h-10 w-10 text-primary" />
              </div>
              <h3 className="text-xl font-semibold text-gray-800 mb-2">Expert Team</h3>
              <p className="text-neutral">Experienced professionals with deep regional knowledge.</p>
            </div>

            <div className="text-center">
              <div className="bg-primary/10 rounded-full p-6 w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                <Globe className="h-10 w-10 text-primary" />
              </div>
              <h3 className="text-xl font-semibold text-gray-800 mb-2">Global Network</h3>
              <p className="text-neutral">Extensive network of partners and agents worldwide.</p>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-gradient-to-r from-primary to-secondary text-white">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Ready to Optimize Your Supply Chain?
          </h2>
          <p className="text-xl text-slate-200 mb-8">
            Contact our logistics experts today to discuss your specific requirements and get a customized solution that fits your business needs.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" className="bg-orange-500 hover:bg-orange-600 text-white">
              <Link href="/quotation">Request Detailed Quote</Link>
            </Button>
            <Button asChild size="lg" variant="outline" className="bg-white/10 backdrop-blur-sm text-white hover:bg-white hover:text-primary border-white/30">
              <Link href="/contact">Schedule Consultation</Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}