export default function StatsSection() {
  const stats = [
    { value: "15+", label: "Years Experience" },
    { value: "2+", label: "Countries Served" },
    { value: "10,000+", label: "Successful Shipments" },
    { value: "100%", label: "Customer Satisfaction" },
  ];

  return (
    <section className="py-16 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
          {stats.map((stat, index) => (
            <div key={index} className="text-center">
              <div className="text-4xl font-bold text-primary mb-2">{stat.value}</div>
              <div className="text-neutral">{stat.label}</div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
