import { Link } from "wouter";
import { Card, CardContent } from "@/components/ui/card";
import { Warehouse, Ship, Truck, FileText, Globe, Heart, Anchor, ArrowRight } from "lucide-react";

export default function ServicesSection() {
  const services = [
    {
      icon: Anchor,
      title: "Sea Port Operations",
      description: "Comprehensive port services at Djibouti seaport including cargo handling, container operations, and vessel management with follow-up of accosting ships and maritime companies.",
      image: "/seaport operations.jpg"
    },
    {
      icon: Warehouse,
      title: "Warehousing & Storage",
      description: "Secure warehouse facilities with inventory management, distribution services, and global vision of the whole supply chain from point of loading up to delivery.",
      image: "/warehouse-interior-with-forklifts-shelving.jpg"
    },
    {
      icon: Ship,
      title: "Freight Forwarding",
      description: "Import/Export by Air, Ocean and road. Multi-modal transportation solutions across East Africa with representative agent services for partner needs in Djibouti and Ethiopia.",
      image: "/Logistic-service-.png"
    },
    {
      icon: FileText,
      title: "Customs Clearance",
      description: "Expert customs documentation and clearance services including preparation of transit files, control of import/export documents, and handling of customs formalities.",
      image: "/customs-clearance.jpg"
    },
    {
      icon: Globe,
      title: "Supply Chain Solutions",
      description: "End-to-end supply chain management with delivery to beforehand indicated sites, pre-routing and choices implementation as regards means to implement.",
      image: "/supply-chain.jpg"
    },
    {
      icon: Heart,
      title: "Customized Services",
      description: "Safely and quick delivery of your cargo with accurate information on daily basis. Step by step follow up and timely information given by Siyan will give you a clear picture of your cargo as if you are on spot.",
      image: "/customized service.jpg"
    },
    {
      icon: Truck,
      title: "Trading Services",
      description: "Representative agent for any partner needs to be represented in Djibouti and Ethiopia. Call of goods abroad at customer request when necessary.",
      image: "/Trading Services.jpg"
    },
    {
      icon: Globe,
      title: "IT Logistics Solutions",
      description: "As information technology expands, we take advantage of the latest technology. Siyan is developing a Tracking system enabling you to trace your shipment whenever and wherever you want.",
      image: "/IT Logistics Solutions.jpg"
    }
  ];

  return (
    <section className="py-20 bg-slate-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl font-bold text-gray-800 mb-4">Our Logistics Services</h2>
          <p className="text-xl text-neutral max-w-3xl mx-auto">
            Siyan provides expert knowledge of the Export/Import business for all types of goods including vehicles and food products. We ensure that shipments are delivered quickly and safely to the door at destination using multi-modal transportation channels.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {services.map((service, index) => {
            const Icon = service.icon;
            return (
              <Card key={index} className="bg-white shadow-lg hover:shadow-xl transition-shadow">
                <CardContent className="p-8">
                  {service.image && (
                    <img 
                      src={service.image} 
                      alt={service.title}
                      className="w-full h-48 object-cover rounded-lg mb-6"
                    />
                  )}
                  <div className="text-primary text-4xl mb-4">
                    <Icon className="h-10 w-10" />
                  </div>
                  <h3 className="text-2xl font-semibold text-gray-800 mb-4">{service.title}</h3>
                  <p className="text-neutral mb-6">{service.description}</p>
                  <Link
                    href={`/learn-more?service=${service.title.toLowerCase().replace(/\s+/g, '-')}`}
                    className="text-primary font-medium hover:text-secondary inline-flex items-center"
                  >
                    Learn More <ArrowRight className="h-4 w-4 ml-1" />
                  </Link>
                </CardContent>
              </Card>
            );
          })}
        </div>
      </div>
    </section>
  );
}
