import { Link } from "wouter";
import { Truck, Linkedin, Twitter, Facebook, MapPin, Phone, Mail } from "lucide-react";

export default function Footer() {
  return (
    <footer className="bg-gray-900 text-white py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 mb-12">
          {/* Company Info */}
          <div>
            <div className="flex items-center text-2xl font-bold mb-4">
              <img
                src="/logo.png"
                alt="SIYAN TRANSIT"
                className="h-8 w-auto mr-2"
              />
            </div>
            <h3 className="text-xl font-semibold mb-4 text-primary">About Siyan</h3>
            <p className="text-gray-300 mb-4">
              Siyan Trans Express is one of the dynamic companies specialized in logistics services (transit, transport, handling) in the region, and Djibouti. We ensure that shipments are delivered quickly and safely to the door at destination using multi-modal transportation channels.
            </p>
            <div className="flex space-x-4">
              <a href="#" className="text-gray-400 hover:text-accent transition-colors">
                <Linkedin className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-accent transition-colors">
                <Twitter className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-accent transition-colors">
                <Facebook className="h-5 w-5" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="text-xl font-semibold mb-4">Quick Links</h3>
            <ul className="space-y-2">
              <li>
                <Link href="/" className="text-gray-300 hover:text-accent transition-colors">
                  Home
                </Link>
              </li>
              <li>
                <Link href="/services" className="text-gray-300 hover:text-accent transition-colors">
                  Services
                </Link>
              </li>
              <li>
                <Link href="/quotation" className="text-gray-300 hover:text-accent transition-colors">
                  Get Quote
                </Link>
              </li>
              <li>
                <Link href="/partners" className="text-gray-300 hover:text-accent transition-colors">
                  Partners
                </Link>
              </li>
              <li>
                <Link href="/contact" className="text-gray-300 hover:text-accent transition-colors">
                  Contact
                </Link>
              </li>
            </ul>
          </div>

          {/* Services */}
          <div>
            <h3 className="text-xl font-semibold mb-4">Our Services</h3>
            <ul className="space-y-2">
              <li>
                <Link href="/services" className="text-gray-300 hover:text-accent transition-colors">
                  Sea Port Operations
                </Link>
              </li>
              <li>
                <Link href="/services" className="text-gray-300 hover:text-accent transition-colors">
                  Freight Forwarding
                </Link>
              </li>
              <li>
                <Link href="/services" className="text-gray-300 hover:text-accent transition-colors">
                  Warehousing
                </Link>
              </li>
              <li>
                <Link href="/services" className="text-gray-300 hover:text-accent transition-colors">
                  Road Transportation
                </Link>
              </li>
              <li>
                <Link href="/services" className="text-gray-300 hover:text-accent transition-colors">
                  Customs Clearance
                </Link>
              </li>
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h3 className="text-xl font-semibold mb-4 text-primary">Contact</h3>
            <div className="space-y-3">
              <div className="flex items-start">
                <MapPin className="h-5 w-5 text-accent mr-3 mt-1 flex-shrink-0" />
                <div className="text-gray-300 text-sm">
                  <div>Rue de Paris</div>
                  <div>Djibouti</div>
                  <div>BP : 4501 Djibouti</div>
                </div>
              </div>
              <div className="flex items-center">
                <Phone className="h-5 w-5 text-accent mr-3 flex-shrink-0" />
                <div className="text-gray-300 text-sm">
                  <div>Directeur général: +253 21 32 72 53</div>
                  <div>Directrice Logistique: +253 21 32 72 55</div>
                  <div>Responsable Gestionnaire: +253 21 32 72 50</div>
                </div>
              </div>
              <div className="flex items-center">
                <Mail className="h-5 w-5 text-accent mr-3 flex-shrink-0" />
                <div className="text-gray-300 text-sm">
                  <div><a href="mailto:aboubaker.pacha@siyan-transit.com" className="hover:text-accent transition-colors">aboubaker.pacha@siyan-transit.com</a></div>
                  <div><a href="mailto:kadidja.ali@siyan-transit.com" className="hover:text-accent transition-colors">kadidja.ali@siyan-transit.com</a></div>
                  <div><a href="mailto:fatouma.mohamed@siyan-transit.com" className="hover:text-accent transition-colors">fatouma.mohamed@siyan-transit.com</a></div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div className="border-t border-gray-800 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <div className="text-gray-400 text-sm mb-4 md:mb-0">
              © 2024 SIYAN TRANSIT. All rights reserved.
            </div>
            <div className="flex space-x-6 text-sm">
              <a href="#" className="text-gray-400 hover:text-accent transition-colors">
                Privacy Policy
              </a>
              <a href="#" className="text-gray-400 hover:text-accent transition-colors">
                Terms of Service
              </a>
              <a href="#" className="text-gray-400 hover:text-accent transition-colors">
                Cookie Policy
              </a>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}
